/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.manager;

import filenet.vw.api.VWDataField;
import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueElement;
import filenet.vw.api.VWQueueQuery;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepElement;
import filenet.vw.api.VWStepProcessorInfo;
import filenet.vw.apps.manager.IVWChunkableQuery;
import filenet.vw.apps.manager.IVWDefinableQuery;
import filenet.vw.apps.manager.VWNodeInformation;
import filenet.vw.apps.manager.images.VWImageLoader;
import filenet.vw.apps.manager.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWOpenItem;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.query.VWPerformSearchEvent;
import filenet.vw.toolkit.utils.table.IVWTableOperation;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import java.awt.Container;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

class VWQueueTableModel
extends AbstractTableModel
implements IVWTableOperation,
IVWDefinableQuery,
IVWChunkableQuery {
    private static final Long NO_DATE = new Long("-2000000000000");
    private static final Long NO_TIMER = new Long("2147483647000");
    private static final Long NO_TIME = new Long("0");
    protected static final int COL_REMINDER = 0;
    protected static final int COL_TYPE = 1;
    protected static final int COL_LOCK = 2;
    private Vector m_headers = new Vector();
    private Vector m_fields = new Vector();
    private Vector m_rowCache = new Vector();
    private Vector m_queueElements = new Vector();
    private String m_currentUserName = null;
    private VWSession m_vwSession = null;
    private Container m_parentContainer = null;
    private VWOpenItem m_vwOpenItem = null;
    private DateFormat m_dateFormatter = null;
    private Icon m_stepIcon = null;
    private Icon m_statusIcon = null;
    private Icon m_unlockedIcon = null;
    private Icon m_lockedByUserIcon = null;
    private Icon m_lockedByOtherIcon = null;
    private Icon m_reminderIcon = null;
    private Icon m_overdueIcon = null;
    private Icon m_completedIcon = null;
    private Icon m_blankIcon = null;
    private String m_queueName = null;
    private VWQueue m_vwQueue = null;
    private VWQueueQuery m_vwQueueQuery = null;
    private String m_queryIndexName = null;
    private Object[] m_queryMinIndexValue = null;
    private Object[] m_queryMaxIndexValue = null;
    private int m_queryFlags = 5;
    private Object[] m_querySubstitutionVars = null;
    private String m_queryFilter = null;
    private boolean m_canPerformNext = false;
    private int m_maxDisplay = 50;
    private int m_numResults = 0;
    private boolean m_hasElements = false;
    private boolean m_OverdueExposed = false;

    public VWQueueTableModel(VWNodeInformation nodeInfo, VWSession vwSession, Container parentContainer, JApplet parentApplet) {
        try {
            this.m_queueName = nodeInfo.getName();
            this.m_queryIndexName = nodeInfo.getDefaultIndexName();
            this.m_vwSession = vwSession;
            this.m_parentContainer = parentContainer;
            this.m_OverdueExposed = nodeInfo.getOverdueExposed();
            this.m_vwOpenItem = new VWOpenItem(vwSession, parentContainer, parentApplet);
            this.m_dateFormatter = DateFormat.getDateTimeInstance(2, 2);
            this.loadIcons();
            this.m_currentUserName = this.m_vwSession.fetchCurrentUserInfo().getName();
            this.m_vwQueue = this.m_vwSession.getQueue(this.m_queueName);
            this.constructColumns(nodeInfo.getSelectedColumns());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_parentContainer, ex, VWResource.s_errorMessage, 0);
            VWDebug.logException(ex);
        }
    }

    public VWQueueTableModel(VWNodeInformation nodeInfo, VWSession vwSession, Container parentContainer, VWPerformSearchEvent searchEvent) {
        try {
            this.m_vwSession = vwSession;
            this.m_parentContainer = parentContainer;
            this.m_queueName = nodeInfo.getName();
            this.m_dateFormatter = DateFormat.getDateTimeInstance(2, 2);
            this.setQueryIndexName(searchEvent.getIndexName());
            this.setQueryMinIndexValue(searchEvent.getMinValues());
            this.setQueryMaxIndexValue(searchEvent.getMaxValues());
            this.setQueryIndexFlags(searchEvent.getIndexFlags());
            this.setQueryFilter(searchEvent.getFilterString());
            this.loadIcons();
            this.m_currentUserName = this.m_vwSession.fetchCurrentUserInfo().getName();
            this.m_vwQueue = this.m_vwSession.getQueue(this.m_queueName);
            this.constructColumns(searchEvent.getColumnNames());
            this.performQuery();
            this.fireTableChanged(new TableModelEvent(this));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void deleteItem(int nRowIndex) {
        try {
            if (nRowIndex < 0) {
                return;
            }
            if (VWStringUtils.compare(this.m_vwQueue.getAuthoredName(), "Tracker") == 0) {
                int nReply = JOptionPane.showConfirmDialog(this.m_parentContainer, VWResource.s_deleteWarning, VWResource.s_deleteConfirmation, 0, 3);
                if (nReply == 1) {
                    return;
                }
                VWStepElement selectedStepElement = ((VWQueueElement)this.m_queueElements.elementAt(nRowIndex)).fetchStepElement(true, true);
                selectedStepElement.doDispatch();
                this.m_rowCache.removeElementAt(nRowIndex);
                this.m_queueElements.removeElementAt(nRowIndex);
                this.fireTableRowsDeleted(nRowIndex, nRowIndex);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Class getColumnClass(int index) {
        Class colClass = null;
        if (!this.m_OverdueExposed) {
            ++index;
        }
        switch (index) {
            case 0: {
                colClass = Icon.class;
                break;
            }
            case 1: {
                colClass = Icon.class;
                break;
            }
            case 2: {
                if (VWStringUtils.compare(this.m_vwQueue.getAuthoredName(), "Tracker") == 0) {
                    colClass = String.class;
                    break;
                }
                colClass = Icon.class;
                break;
            }
            default: {
                colClass = String.class;
            }
        }
        return colClass;
    }

    public int getColumnCount() {
        return this.m_headers.size();
    }

    public String getColumnName(int index) {
        if (index >= this.m_headers.size()) {
            return " ";
        }
        return (String)this.m_headers.elementAt(index);
    }

    public int getRowCount() {
        return this.m_rowCache.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex > this.getRowCount() - 1) {
            return null;
        }
        if (columnIndex > this.m_headers.size() - 1) {
            return null;
        }
        Vector rowData = (Vector)this.m_rowCache.elementAt(rowIndex);
        if (rowData != null) {
            return rowData.elementAt(columnIndex);
        }
        return null;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex > this.getRowCount() - 1) {
            return;
        }
        if (columnIndex > this.m_headers.size() - 1) {
            return;
        }
    }

    public void openItem(int rowIndex) {
        block8: {
            try {
                String lockedUser;
                if (VWStringUtils.compare(this.m_vwQueue.getAuthoredName(), "Conductor") == 0) {
                    JOptionPane.showMessageDialog(this.m_parentContainer, VWResource.s_itemsInConductorQueue, VWResource.s_cannotOpenItem, 0);
                    return;
                }
                VWQueueElement selectedElement = (VWQueueElement)this.m_queueElements.elementAt(rowIndex);
                if (selectedElement.hasFieldName("F_Locked") && (Integer)selectedElement.getFieldValue("F_Locked") != 0 && !VWStringUtils.compareUsers(lockedUser = selectedElement.getLockedUser(), this.m_currentUserName)) {
                    JOptionPane.showMessageDialog(this.m_parentContainer, VWResource.s_itemLocked, VWResource.s_cannotOpenItem, 1);
                    return;
                }
                if (VWStringUtils.compare(this.m_vwQueue.getAuthoredName(), "Tracker") == 0) {
                    this.m_vwOpenItem.openStatusTracker(this.m_queueName, selectedElement.getWorkObjectNumber());
                    break block8;
                }
                VWStepProcessorInfo stepProcessorInfo = null;
                try {
                    stepProcessorInfo = selectedElement.fetchStepProcessorInfo();
                }
                catch (VWException ex) {
                    VWDebug.logException(ex);
                }
                if (this.m_vwQueue.getQueueType() == 2 && this.m_queueName != null && !this.m_queueName.endsWith("(0)")) {
                    this.m_queueName = this.m_queueName + "(0)";
                }
                this.m_vwOpenItem.openStepProcessor(this.m_queueName, selectedElement.getWorkObjectNumber(), selectedElement.getStepName(), stepProcessorInfo);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    public void refresh() {
        this.m_rowCache.removeAllElements();
        this.m_queueElements.removeAllElements();
        this.performQuery();
        this.fireTableDataChanged();
    }

    public void setQueryIndexName(String name) {
        this.m_queryIndexName = name;
    }

    public void setQueryMinIndexValue(Object[] minValues) {
        this.m_queryMinIndexValue = minValues;
    }

    public void setQueryMaxIndexValue(Object[] maxValues) {
        this.m_queryMaxIndexValue = maxValues;
    }

    public void setQueryIndexFlags(int indexFlags) {
        this.m_queryFlags = 5;
        this.m_queryFlags |= indexFlags;
    }

    public void setQueryFilter(String filter) {
        this.m_queryFilter = filter;
    }

    public void setSelectedColumns(String[] columns) {
        try {
            this.m_headers.removeAllElements();
            this.m_fields.removeAllElements();
            this.constructColumns(columns);
            this.fireTableStructureChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean getCanPerformNext() {
        return this.m_canPerformNext;
    }

    public void setMaxRowsDisplayed(int maxRows) {
        this.m_maxDisplay = maxRows;
    }

    public int getMaxRowsDisplayed() {
        return this.m_maxDisplay;
    }

    public boolean getHasElements() {
        return this.m_hasElements;
    }

    public void performNext() {
        this.m_rowCache.removeAllElements();
        this.m_queueElements.removeAllElements();
        this.retrieveRowData();
        this.fireTableDataChanged();
    }

    public int getQueryResultsCount() {
        return this.m_numResults;
    }

    private void constructColumns(String[] columns) {
        try {
            if (columns == null || columns.length < 1) {
                return;
            }
            if (this.m_OverdueExposed) {
                this.m_headers.addElement(" ");
                this.m_fields.addElement(" ");
            }
            this.m_headers.addElement(" ");
            this.m_fields.addElement(" ");
            if (VWStringUtils.compare(this.m_vwQueue.getAuthoredName(), "Tracker") != 0) {
                this.m_headers.addElement(" ");
                this.m_fields.addElement(" ");
            }
            for (int i = 0; i < columns.length; ++i) {
                this.m_headers.addElement(columns[i]);
                this.m_fields.addElement(columns[i]);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performQuery() {
        try {
            if (this.m_vwQueue == null) {
                return;
            }
            if (this.getColumnCount() < 1) {
                return;
            }
            this.m_vwQueueQuery = this.m_vwQueue.createQuery(this.m_queryIndexName, this.m_queryMinIndexValue, this.m_queryMaxIndexValue, this.m_queryFlags, this.m_queryFilter, this.m_querySubstitutionVars, 3);
            this.m_numResults = this.m_vwQueueQuery.fetchCount();
            this.retrieveRowData();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_parentContainer, ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
            VWDebug.logException(ex);
        }
    }

    private void retrieveRowData() {
        try {
            int counter = 0;
            this.m_hasElements = false;
            VWQueueElement curElement = (VWQueueElement)this.m_vwQueueQuery.next();
            while (curElement != null && counter < this.m_maxDisplay) {
                this.m_hasElements = true;
                ++counter;
                Vector<Object> rowData = new Vector<Object>();
                if (this.m_OverdueExposed) {
                    switch (curElement.getStepDeadlineStatus()) {
                        case 1: {
                            rowData.addElement(this.m_reminderIcon);
                            break;
                        }
                        case 2: {
                            rowData.addElement(this.m_overdueIcon);
                            break;
                        }
                        case 3: {
                            rowData.addElement(this.m_completedIcon);
                            break;
                        }
                        default: {
                            rowData.addElement(this.m_blankIcon);
                        }
                    }
                }
                if (VWStringUtils.compare(this.m_vwQueue.getAuthoredName(), "Tracker") == 0) {
                    rowData.addElement(this.m_statusIcon);
                } else {
                    rowData.addElement(this.m_stepIcon);
                    if (curElement.hasFieldName("F_Locked")) {
                        if ((Integer)curElement.getFieldValue("F_Locked") == 0) {
                            rowData.addElement(this.m_unlockedIcon);
                        } else {
                            String lockedUser = curElement.getLockedUser();
                            if (VWStringUtils.compareUsers(lockedUser, this.m_currentUserName)) {
                                rowData.addElement(this.m_lockedByUserIcon);
                            } else {
                                rowData.addElement(this.m_lockedByOtherIcon);
                            }
                        }
                    } else {
                        rowData.addElement(this.m_unlockedIcon);
                    }
                }
                for (int col = 0; col < this.getColumnCount(); ++col) {
                    String fieldName = this.getColumnField(col);
                    if (curElement.hasFieldName(fieldName)) {
                        String authoredFieldName = fieldName;
                        Object fieldValue = null;
                        VWDataField dataField = curElement.getDataField(fieldName);
                        if (dataField != null) {
                            authoredFieldName = dataField.getAuthoredName();
                            fieldValue = dataField.getValue();
                        } else {
                            fieldValue = curElement.getFieldValue(fieldName);
                        }
                        if (VWStringUtils.compare(authoredFieldName, "F_LockUser") == 0 || VWStringUtils.compare(authoredFieldName, "F_BoundUser") == 0) {
                            if (fieldValue != null && fieldValue instanceof Integer) {
                                try {
                                    VWParticipant participant = this.m_vwSession.convertIdToUserNamePx(((Integer)fieldValue).intValue());
                                    VWParticipantItem pItem = new VWParticipantItem(participant);
                                    String user = ((Integer)fieldValue).toString() + "(" + pItem.getDisplayName() + ")";
                                    rowData.addElement(user);
                                }
                                catch (Exception ex) {
                                    rowData.addElement(fieldValue);
                                }
                                continue;
                            }
                            rowData.addElement(fieldValue);
                            continue;
                        }
                        if (VWStringUtils.compare(authoredFieldName, "F_Subject") == 0) {
                            rowData.addElement(curElement.getSubject());
                            continue;
                        }
                        if (fieldValue != null && fieldValue instanceof Date) {
                            if (NO_TIME.longValue() != ((Date)fieldValue).getTime() && NO_TIMER.longValue() != ((Date)fieldValue).getTime() && NO_DATE.longValue() != ((Date)fieldValue).getTime()) {
                                rowData.addElement(this.m_dateFormatter.format((Date)fieldValue));
                                continue;
                            }
                            rowData.addElement(" ");
                            continue;
                        }
                        rowData.addElement(fieldValue);
                        continue;
                    }
                    if (VWStringUtils.compare(fieldName, "F_StepLabel") == 0) {
                        rowData.addElement(curElement.getStepName());
                        continue;
                    }
                    if (fieldName == " ") continue;
                    rowData.addElement(" ");
                }
                this.m_rowCache.addElement(rowData);
                this.m_queueElements.addElement(curElement);
                if (counter >= this.m_maxDisplay) continue;
                curElement = (VWQueueElement)this.m_vwQueueQuery.next();
            }
            this.m_canPerformNext = this.m_vwQueueQuery.hasNext();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_parentContainer, ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
            VWDebug.logException(ex);
        }
    }

    private void loadIcons() {
        try {
            this.m_stepIcon = VWImageLoader.createImageIcon("step.gif");
            this.m_statusIcon = VWImageLoader.createImageIcon("tracker.gif");
            this.m_unlockedIcon = VWImageLoader.createImageIcon("unlocked.gif");
            this.m_lockedByUserIcon = VWImageLoader.createImageIcon("lockedbyuser.gif");
            this.m_lockedByOtherIcon = VWImageLoader.createImageIcon("lockedbyother.gif");
            this.m_reminderIcon = VWImageLoader.createImageIcon("reminder.gif");
            this.m_overdueIcon = VWImageLoader.createImageIcon("overdue.gif");
            this.m_completedIcon = VWImageLoader.createImageIcon("completed.gif");
            this.m_blankIcon = VWImageLoader.createImageIcon("blank.gif");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private String getColumnField(int index) {
        if (index >= this.m_fields.size()) {
            return " ";
        }
        return (String)this.m_fields.elementAt(index);
    }
}

